/*
  LuxTag Sampler.js
  
  
*/

// global variables.
var version_num = "0.1";

var samplers = ["metropolis","erpt","lowdiscrepancy","random"];
var pixel_samplers = ["linear", "tile", "random", "vegas", "lowdiscrepancy", "hilbert"];

function buildUI( tag ) {
	
	tag.addParameterSeparator("[ Sampler ]");
	tag.addParameterSelector("sampler", samplers, false, false);
	
	tag.addParameterSeparator("random option");
	tag.addParameterSelector("ram::pixelsampler", pixel_samplers, false, false);
	tag.addParameterInt("ram::xsamples", 2, 1, 512, false, false);
	tag.addParameterInt("ram::ysamples", 2, 1, 512, false, false);

	tag.addParameterSeparator("lowdiscrepancy option");
	tag.addParameterSelector("low::pixelsampler", pixel_samplers, false, false);
	tag.addParameterInt("low::pixelsamples", 4, 1, 2048, false, false);
	
	tag.addParameterSeparator("metropolis option");
	
	tag.addParameterFloat("metr::strength", 0.6, 0, 1, false, false);
	
	tag.addParameterBool("metr::use advanced", 0, 0, 1, false, false);
	
	tag.addParameterFloat("metr::largemutationprob", 0.4, 0.0, 1.0, false, false);
	tag.addParameterInt("metr::maxconsecrejects", 512, 1, 32768, false, false);
	tag.addParameterInt("metr::initsamples", 262144, 1, 1000000, false, false);
	tag.addParameterInt("metr::stratawidth", 256, 1, 32768, false, false);
	tag.addParameterBool("metr::usevariance", 0, 0, 1, false, false);
	
	tag.addParameterSeparator("erpt option");
	
	tag.addParameterInt("erpt::initsamples", 100000, 1, 1000000, false, false);
	tag.addParameterInt("erpt::chainlength", 512, 1, 32768, false, false);
	tag.addParameterInt("erpt::stratawidth", 256, 1, 32768, false, false);

}
